﻿using UnityEngine;
using UnityEditor;
using FullControl.Tx.View;

public class RevertSelectedPrefabsTool : EditorWindow 
{


	[MenuItem("Window/Revert Selected Prefabs Tool")]
	public static void ShowWindow()
	{
		//Show existing window instance. If one doesn't exist, make one.
		EditorWindow.GetWindow(typeof(RevertSelectedPrefabsTool));
	}
	
	void OnGUI()
	{
		GUILayout.Label ("Push the button to revert", EditorStyles.boldLabel);
		GUILayout.Label ("the selected objects.", EditorStyles.boldLabel);
		
		int wasReverted = 0;
		
		if(GUILayout.Button("Revert them all!"))
		{
			wasReverted = RevertSelectedPrefabs ();
			Debug.Log("Reverted " + wasReverted + " objects. Thank you Rasmus!");
		}
	}

	int RevertSelectedPrefabs()
	{
		GameObject[] selectedObjects = Selection.gameObjects;
		int numberOfSelectedObjects = selectedObjects.Length;
		
		for (int i = 0; i < numberOfSelectedObjects; i++) 
		{
			PrefabUtility.RevertPrefabInstance( selectedObjects[i] );

			
		}
		return numberOfSelectedObjects;
	}
}
